<?php
require_once "helpers.php";
require_once "ai.php";

$update   = json_decode(file_get_contents("php://input"), true);

$message    = $update["message"]["text"]  ?? null;
$chat_id    = $update["message"]["chat"]["id"] ?? null;
$username   = $update["message"]["from"]["username"] ?? "";
$user_id_tg = $update["message"]["from"]["id"] ?? null;

if (!$chat_id || (!$message && empty($update['message']['voice']))) {
    exit;
}

// ثبت/به‌روز کاربر
$user_id = find_or_create_user($user_id_tg, $username);

// دکمه‌های منو (متن‌ها از تنظیمات پنل)
$support_btn = get_setting('support_button_label', '🧑‍💻 شروع مکالمه');
$end_btn     = get_setting('end_button_label', '❌ پایان مکالمه');

// کیبوردها
$kb_start = [
    "keyboard" => [
        [ ["text" => $support_btn] ]
    ],
    "resize_keyboard" => true
];

$kb_end = [
    "keyboard" => [
        [ ["text" => $end_btn] ]
    ],
    "resize_keyboard" => true
];

// وضعیت مکالمه این کاربر (در settings ذخیره می‌کنیم)
$chat_active_key = 'chat_active_' . $user_id_tg;
$is_chat_active  = (get_setting($chat_active_key, '0') === '1');

// =================== هندل /start ===================
if ($message === "/start") {
    // مکالمه را خاموش کن
    set_setting($chat_active_key, '0');

    $welcome = get_setting('welcome_text', 'سلام 👋 به ربات پشتیبانی خوش آمدید.');
    tg_send($chat_id, $welcome, $kb_start);
    exit;
}

// =================== دکمه‌ها ===================

// شروع مکالمه
if ($message === $support_btn) {

    // فعال کردن مکالمه برای این کاربر
    set_setting($chat_active_key, '1');
    $is_chat_active = true;

    $txt = get_setting('support_text', 'مکالمه با پشتیبان هوشمند فعال شد 🌸 لطفاً سؤال خود را بپرسید.');
    tg_send($chat_id, $txt, $kb_end);
    exit;
}

// پایان مکالمه
if ($message === $end_btn) {

    // غیرفعال کردن مکالمه
    set_setting($chat_active_key, '0');
    $is_chat_active = false;

    // پیام اول: پایان مکالمه
    tg_send($chat_id, "مکالمه پایان یافت ✅");

    // پیام دوم: منوی اصلی (همان welcome_text)
    $welcome = get_setting('welcome_text', 'سلام 👋 به ربات پشتیبانی خوش آمدید.');
    tg_send($chat_id, $welcome, $kb_start);

    exit;
}

// =================== دستورات مخصوص ادمین ===================

if (strpos($message, "/setbiz") === 0 && is_tg_admin($user_id_tg)) {
    // تنظیم business_info
    $text = trim(mb_substr($message, strlen("/setbiz")));
    if ($text === "") {
        tg_send($chat_id, "متن توضیحات کسب‌وکار را بعد از دستور بنویس.\nمثال:\n/setbiz ما یک مرکز خدمات کامپیوتری هستیم ...");
    } else {
        set_setting('business_info', $text);
        tg_send($chat_id, "✔ اطلاعات کلی کسب‌وکار ذخیره شد.");
    }
    exit;
}

if (strpos($message, "/setrules") === 0 && is_tg_admin($user_id_tg)) {
    $text = trim(mb_substr($message, strlen("/setrules")));
    if ($text === "") {
        tg_send($chat_id, "قوانین پاسخگویی را بعد از دستور بنویس.\nمثال:\n/setrules پاسخ‌ها کوتاه باشند، لحن دوستانه باشد ...");
    } else {
        set_setting('ai_rules', $text);
        tg_send($chat_id, "✔ قوانین پاسخگویی ذخیره شد.");
    }
    exit;
}

if ($message === "/tone_formal" && is_tg_admin($user_id_tg)) {
    set_setting('ai_tone', 'formal');
    tg_send($chat_id, "✔ لحن پاسخگویی روی رسمی تنظیم شد.");
    exit;
}

if ($message === "/tone_casual" && is_tg_admin($user_id_tg)) {
    set_setting('ai_tone', 'casual');
    tg_send($chat_id, "✔ لحن پاسخگویی روی عامیانه تنظیم شد.");
    exit;
}

// =================== پیام کاربر معمولی ===================

if ($message) {

    // اگر مکالمه فعال نیست، به کاربر بگو اول روی شروع مکالمه بزند
    if (!$is_chat_active) {
        tg_send($chat_id, "برای شروع گفتگو با پشتیبان هوشمند، روی دکمه «{$support_btn}» بزنید 🌸", $kb_start);
        exit;
    }

    // محدودیت روزانه
    if (!check_daily_limit($user_id)) {
        $limit_msg = get_setting('limit_text', 'شما به سقف تعداد پیام مجاز امروز رسیده‌اید.');
        tg_send($chat_id, $limit_msg, $kb_end);
        exit;
    }

    // ذخیره پیام کاربر
    save_message($user_id, 'user', 'text', $message);

    // گرفتن پاسخ AI
    $reply = ai_reply($message, $user_id);

    // ذخیره پاسخ ربات
    save_message($user_id, 'bot', 'text', $reply);

    // افزایش شمارنده روزانه
    increment_daily_count($user_id);

    // ارسال پاسخ AI در حالت مکالمه فعال
    tg_send($chat_id, $reply, $kb_end);
    exit;
}
