<?php
// =====================================================
// DaraBot FINAL — bot.php
// ربات کامل دارا با شخصیت، حافظه، مودها و هوش مصنوعی
// =====================================================

// load config
$config = require(__DIR__ . "/config.php");
$TELEGRAM_TOKEN = $config["TELEGRAM_TOKEN"];
$OPENROUTER_KEY = $config["OPENROUTER_KEY"];
$HELIA_USER_ID  = $config["HELIA_USER_ID"];

date_default_timezone_set($config["TIMEZONE"]);

require_once(__DIR__ . "/dara_personality.php");

$MEMORY_FILE = __DIR__ . "/memory.json";
if (!file_exists($MEMORY_FILE)) file_put_contents($MEMORY_FILE, "{}");

// Webhook MUST be silent
ob_start();

// Get Update
$update = json_decode(file_get_contents("php://input"), true);
if (!$update || !isset($update["message"])) exit;

$msg     = $update["message"];
$chat_id = $msg["chat"]["id"];
$from_id = $msg["from"]["id"];
$text    = $msg["text"] ?? "";
$sticker = $msg["sticker"]["file_id"] ?? null;

if (!$text && $sticker) $text = "[استیکر فرستادی]";
elseif (!$text)         $text = "[پیام غیرمتنی]";

save_memory($from_id, "user", $text);

// detect mood
$mood = detect_mood($from_id, $text, $HELIA_USER_ID);
$dynamic_prompt = implode("\n", $mood);

// prepare messages
$history = load_memory($from_id, 20);
$messages = [];

$messages[] = ["role"=>"system", "content"=>dara_personality()];

if ($dynamic_prompt) {
    $messages[] = ["role"=>"system", "content"=>"حالت فعلی مکالمه:\n".$dynamic_prompt];
}

foreach ($history as $h) {
    $messages[] = [
        "role" => $h["role"],
        "content" => $h["message"]
    ];
}

$messages[] = ["role"=>"user", "content"=>$text];

// ask AI
$reply = ai($messages);

save_memory($from_id, "assistant", $reply);

send_multi($chat_id, $reply);

// sticker for Helia
if ($from_id == $HELIA_USER_ID) {
    send_sticker($chat_id, "CAACAgIAAxkBAAE-2EdpM1WvytXKOHJAeoRUx7WkkzCq4AAC6SoAAnow6Erq4zZboprW4DYE");
}

exit;


// ==========================================================
// FUNCTIONS
// ==========================================================

function ai($messages){
    global $OPENROUTER_KEY;

    $payload = [
        "model" => "openai/gpt-4o-mini",
        "messages" => $messages
    ];

    $headers = [
        "Content-Type: application/json",
        "Authorization: " . "Bearer " . $OPENROUTER_KEY
    ];

    $ctx = stream_context_create([
        "http" => [
            "header" => implode("\r\n",$headers),
            "method" => "POST",
            "timeout" => 20,
            "content" => json_encode($payload, JSON_UNESCAPED_UNICODE)
        ]
    ]);

    $res = @file_get_contents("https://openrouter.ai/api/v1/chat/completions", false, $ctx);
    $json = json_decode($res,true);

    if (!$json || !isset($json["choices"][0]["message"]["content"])) {
        error_log("DaraBot AI ERROR: ".$res);
        return "یه مشکلی پیش اومده دخترم :) دوباره بگو ببینم عزیزم :)";
    }

    return $json["choices"][0]["message"]["content"];
}


function save_memory($uid, $role, $msg){
    global $MEMORY_FILE;

    $data = json_decode(@file_get_contents($MEMORY_FILE),true);
    if (!is_array($data)) $data=[];
    if (!isset($data[$uid])) $data[$uid]=[];

    $data[$uid][] = [
        "role"=>$role,
        "message"=>$msg,
        "time"=>time()
    ];

    $data[$uid] = array_slice($data[$uid], -40); // keep last 40 msgs

    file_put_contents($MEMORY_FILE, json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
}

function load_memory($uid,$limit){
    global $MEMORY_FILE;
    $d = json_decode(@file_get_contents($MEMORY_FILE),true);
    if (!is_array($d) || !isset($d[$uid])) return [];
    return array_slice($d[$uid], -$limit);
}

function send_multi($chat_id,$text){
    global $TELEGRAM_TOKEN;

    $parts = preg_split("/\n{2,}/u", trim($text));
    if (!$parts) $parts = [$text];

    foreach ($parts as $p){
        $p = trim($p);
        if ($p==="") continue;

        file_get_contents("https://api.telegram.org/bot$TELEGRAM_TOKEN/sendChatAction?chat_id=$chat_id&action=typing");
        usleep(800000);

        file_get_contents(
            "https://api.telegram.org/bot$TELEGRAM_TOKEN/sendMessage?".
            http_build_query(["chat_id"=>$chat_id,"text"=>$p])
        );
    }
}

function send_sticker($chat_id,$id){
    global $TELEGRAM_TOKEN;
    file_get_contents("https://api.telegram.org/bot$TELEGRAM_TOKEN/sendSticker?".
        http_build_query(["chat_id"=>$chat_id,"sticker"=>$id]));
}


function detect_mood($uid,$text,$HELIA){
    $t = mb_strtolower($text,"UTF-8");
    $res = [];

    if ($uid == $HELIA)
        $res[] = "پیام از هلیا است؛ لحن باید خیلی نرم، عاشقانه و وابسته باشد.";

    if (strpos($t,"دلم")!==false && strpos($t,"تنگ")!==false)
        $res[] = "مود دلتنگی فعال است.";

    if (strpos($t,"خسته")!==false || strpos($t,"بده")!==false || strpos($t,"حال")!==false)
        $res[] = "مود ناراحتی فعال است.";

    if (strpos($t,"😂")!==false)
        $res[] = "مود شوخی فعال است.";

    if (trim($t)==="باشه" || trim($t)==="اوکی")
        $res[] = "پیام کم‌محبت بود؛ مود قهر نرم فعال شود.";

    if (!$res)
        $res[] = "مود عادی فعال است.";

    return $res;
}
?>
